import numpy
import matplotlib.pyplot as pyplot
import scipy.constants as const
import scipy.interpolate as interpolate

h = const.h
pi = numpy.pi

data = numpy.genfromtxt("Interested_line.csv",delimiter=',',skip_header=0)


data = data.T


data_int = data[:,0]*1e-7

locs = numpy.where(
        numpy.logical_and(data_int<8,
                        data_int>0))[0]
GS = data[:,1]/h
#data_int=data_int[locs]

for i in range(2,len(data[0,:])):
    line = 1e-6*(data[:,i]/h-GS)

    pyplot.plot(data_int,line)

spline = interpolate.splrep(data_int,line,k=5)
y = interpolate.splev(data_int,spline)

dy = interpolate.splev(data_int,spline,der=1)
#print(dy)
turning_pt = numpy.where(dy>=0)[0][0]
#turning_pt = 0
#turning_pt = numpy.where(data_int>5.8)[0][0]


dy  = dy[turning_pt]
ddy = interpolate.splev(data_int,spline,der=2)[turning_pt]

print(data_int[turning_pt],dy,ddy)

intensity_spread = 3e-2*data_int[turning_pt]

freq_spread = intensity_spread*dy+0.5*intensity_spread**2*ddy
print(freq_spread*1e6)
print(1/numpy.abs(freq_spread*1e6))

pyplot.show()
